/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.security;

import com.ibm.hsc.security.HscPermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HscPermission
extends Permission
implements Serializable {
    static Hashtable opList = new Hashtable(5);
    static final String[] actList = new String[]{"activate", "copy", "create", "delete", "modify", "view", "defaultprofile", "osreset", "openterm", "closeterm", "poweron", "poweroff", "unlock", "backup", "restore", "buildhsc", "killterm", "initProfData", "readlparerrval", "none"};
    static final byte[] cecActs = new byte[]{3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19};
    static final byte[] lparActs = new byte[]{0, 2, 3, 4, 5, 7, 8, 9, 16, 18, 19};
    static final byte[] pparActs = new byte[]{0, 2, 3, 4, 5, 7, 8, 9, 16, 18, 19};
    static final byte[] lprofActs = new byte[]{0, 1, 2, 3, 4, 5, 6, 19};
    static final byte[] sprofActs = new byte[]{0, 1, 2, 3, 4, 5, 19};
    static final byte[] hscActs = new byte[]{15, 19};
    static final byte[] dlparActs = new byte[]{4, 14, 19};
    static final byte[] cuodActs = new byte[]{0, 4, 5, 19};
    static final byte[] bpaActs = new byte[]{5, 10, 11, 14, 19};
    static final byte[] ledActs = new byte[]{0, 5, 19};
    static final int ALL_PERMISSION = 0xFFFFFF;
    public static final String HSC_TARGET_CEC = "cec";
    public static final String HSC_TARGET_LPAR = "lpar";
    public static final String HSC_TARGET_PPAR = "ppar";
    public static final String HSC_TARGET_DLPAR = "dlpar";
    public static final String HSC_TARGET_CUOD = "cuod";
    public static final String HSC_TARGET_BPA = "bpa";
    public static final String HSC_TARGET_LPARPROFILE = "lparprofile";
    public static final String HSC_TARGET_SYSPROFILE = "sysprofile";
    public static final String HSC_TARGET_HSC = "hsc";
    public static final String HSC_TARGET_LED = "led";
    public static final String HSC_ACTION_ACTIVATE = actList[0];
    public static final String HSC_ACTION_COPY = actList[1];
    public static final String HSC_ACTION_CREATE = actList[2];
    public static final String HSC_ACTION_DELETE = actList[3];
    public static final String HSC_ACTION_MODIFY = actList[4];
    public static final String HSC_ACTION_VIEW = actList[5];
    public static final String HSC_ACTION_DEFPROFILE = actList[6];
    public static final String HSC_ACTION_OSRESET = actList[7];
    public static final String HSC_ACTION_OPENTERM = actList[8];
    public static final String HSC_ACTION_CLOSETERM = actList[9];
    public static final String HSC_ACTION_POWERON = actList[10];
    public static final String HSC_ACTION_POWEROFF = actList[11];
    public static final String HSC_ACTION_UNLOCK = actList[12];
    public static final String HSC_ACTION_BACKUP = actList[13];
    public static final String HSC_ACTION_RESTORE = actList[14];
    public static final String HSC_ACTION_BUILDHSC = actList[15];
    public static final String HSC_ACTION_KILLTERM = actList[16];
    public static final String HSC_ACTION_INITPROFDATA = actList[17];
    public static final String HSC_ACTION_READLPARERRVAL = actList[18];
    public static final String HSC_ACTION_NONE = actList[19];
    int actionFlag = 0;

    private void checkName(String string) {
        if (string == null) {
            throw new NullPointerException("Operation-Name can't be null!");
        }
        if (string.equalsIgnoreCase("AllPermission")) {
            this.actionFlag = 0xFFFFFF;
            return;
        }
        Object v = opList.get(string.toLowerCase());
        if (v == null) {
            throw new IllegalArgumentException("Invalid Permission-Name (" + string + ")!");
        }
    }

    private void setActions(String string) {
        if (this.actionFlag == 0xFFFFFF) {
            return;
        }
        if (string == null) {
            return;
        }
        byte[] byArray = (byte[])opList.get(this.getName().toLowerCase());
        if (string.equalsIgnoreCase("allactions")) {
            int n = 0;
            while (n < byArray.length) {
                this.actionFlag |= 1 << n;
                ++n;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = 0;
            while (n < byArray.length) {
                if (actList[byArray[n]].equalsIgnoreCase(string2)) {
                    this.actionFlag |= 1 << n;
                    break;
                }
                ++n;
            }
            if (n < byArray.length) continue;
            throw new IllegalArgumentException("Invalid Action (" + string2 + ")!");
        }
    }

    public HscPermission(String string) {
        super(string);
        this.checkName(string);
    }

    public HscPermission(String string, String string2) {
        super(string);
        this.checkName(string);
        this.setActions(string2);
    }

    public boolean implies(Permission permission) {
        if (permission == null || permission.getClass() != this.getClass()) {
            return false;
        }
        if (this.actionFlag == 0xFFFFFF) {
            return true;
        }
        HscPermission hscPermission = (HscPermission)permission;
        String string = hscPermission.getName();
        int n = hscPermission.actionFlag;
        return string.equalsIgnoreCase(this.getName()) && (n & this.actionFlag) == n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        HscPermission hscPermission = (HscPermission)object;
        return this.getName().equals(hscPermission.getName()) && this.actionFlag == hscPermission.actionFlag;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        boolean bl = false;
        int n = this.actionFlag;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = (byte[])opList.get(this.getName().toLowerCase());
        if (n == 0xFFFFFF) {
            stringBuffer.append("<All Operations, All Actions>");
        } else {
            int n2 = 0;
            while (n2 < byArray.length) {
                if ((n >> n2 & 1) == 1) {
                    if (!bl) {
                        bl = true;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(actList[byArray[n2]]);
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public PermissionCollection newPermissionCollection() {
        return new HscPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    static {
        opList.put(HSC_TARGET_CEC, cecActs);
        opList.put(HSC_TARGET_LPAR, lparActs);
        opList.put(HSC_TARGET_PPAR, pparActs);
        opList.put(HSC_TARGET_LPARPROFILE, lprofActs);
        opList.put(HSC_TARGET_SYSPROFILE, sprofActs);
        opList.put(HSC_TARGET_HSC, hscActs);
        opList.put(HSC_TARGET_DLPAR, dlparActs);
        opList.put(HSC_TARGET_CUOD, cuodActs);
        opList.put(HSC_TARGET_BPA, bpaActs);
        opList.put(HSC_TARGET_LED, ledActs);
    }
}

